<?php
/**
 * Plugin Name: KM Custom CSS
*/

// Hier wird die Options Page Registriert
function km_css_options_page(){
	$hookname = add_menu_page(
		'KM Custom CSS',
		'KM Search Options',
		'manage_options',
		plugin_dir_path(__FILE__) . 'settings/main.php',
		null,
		plugin_dir_url(__FILE__) . 'dist/img/plugin_logo.svg',
		20
	);
}
add_action('admin_menu', 'km_css_options_page');


// Hier werden die Scripts und Styles von Codemirror geladen
function codemirror_enqueue_scripts($hook) {
  $cm_settings['codeEditor'] = wp_enqueue_code_editor(array('type' => 'text/css'));
  wp_localize_script('jquery', 'cm_settings', $cm_settings);
 
  wp_enqueue_script( 'my_custom_script', plugin_dir_url( __FILE__ ) . 'js/wp-theme-plugin-editor.js' );
  wp_enqueue_style('wp-codemirror');

  wp_enqueue_script( 'toggle_km_js', plugin_dir_url(__FILE__) . 'js/toggle.js' ); 

}
add_action('admin_enqueue_scripts', 'codemirror_enqueue_scripts');




// Hier werden die Settings registriert
function register_my_setting_css() {
 register_setting( 'km_custom_css_settings', 'km_custom_css' ); 
  } 
add_action( 'admin_init', 'register_my_setting_css' );


// Hier wird das Stylesheet des Plugins geladen
function km_custom_css_enqueue_style() {
	wp_enqueue_style( 'custom_css', plugin_dir_url(__FILE__) . '/css/style.css' ); 

}
add_action( 'wp_enqueue_scripts', 'km_custom_css_enqueue_style' );


// Hier wird das Stylesheet des Plugins geladen
function km_custom_css_enqueue_admin_style() {
	wp_enqueue_style( 'custom_css', plugin_dir_url(__FILE__) . '/css/admin-style.css' ); 

}
add_action( 'admin_enqueue_scripts', 'km_custom_css_enqueue_admin_style' );
